/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWXMLData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWFieldsCellRenderer
extends DefaultTableCellRenderer {
    private static final int MAX_CHARS_DISPLAYED = 100;
    private static final int MAX_XML_CHARS_DISPLAYED = 1024;
    private static final int DIGITS_MIN = 1;
    private static final int DIGITS_MAX = 6;
    private static final Long NO_DATE = new Long("-2000000000000");
    private static final Long NO_TIMER = new Long("2147483647000");
    private static final Long NO_TIME = new Long("0");
    private static final NumberFormat s_numberFormatter = NumberFormat.getInstance();

    public VWFieldsCellRenderer() {
        s_numberFormatter.setMinimumFractionDigits(1);
        s_numberFormatter.setMaximumFractionDigits(6);
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        String string = "";
        if (value instanceof Vector) {
            string = VWResource.s_variousValues;
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            if (array.length == 0) {
                return null;
            }
            if (array instanceof Boolean[]) {
                for (int i = 0; i < array.length; ++i) {
                    Boolean bool;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((bool = (Boolean)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(bool);
                }
            } else if (array instanceof Date[]) {
                for (int i = 0; i < array.length; ++i) {
                    Date date;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((date = (Date)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(date);
                }
            } else if (array instanceof Double[]) {
                for (int i = 0; i < array.length; ++i) {
                    Double aDouble;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((aDouble = (Double)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(aDouble);
                }
            } else if (array instanceof Float[]) {
                for (int i = 0; i < array.length; ++i) {
                    Float aFloat;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((aFloat = (Float)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(aFloat);
                }
            } else if (array instanceof VWAttachment[]) {
                for (int i = 0; i < array.length; ++i) {
                    VWAttachment attachment;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((attachment = (VWAttachment)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(attachment);
                }
            } else if (array instanceof VWParticipant[]) {
                for (int i = 0; i < array.length; ++i) {
                    VWParticipant participant;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((participant = (VWParticipant)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(participant);
                }
            } else if (array instanceof VWXMLData[]) {
                for (int i = 0; i < array.length; ++i) {
                    VWXMLData xmlData;
                    if (i != 0) {
                        string = string + ";";
                    }
                    if ((xmlData = (VWXMLData)array[i]) == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(xmlData);
                }
            } else if (array instanceof VWGuid[]) {
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        string = string + ";";
                    }
                    if (array[i] == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + VWFieldsCellRenderer.toString(array[i]);
                }
            } else {
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        string = string + ";";
                    }
                    if (array[i] == null) continue;
                    if (string.length() > 100) {
                        string = string + VWResource.s_dots;
                        break;
                    }
                    string = string + array[i].toString();
                }
            }
        } else if (value instanceof Boolean) {
            string = VWFieldsCellRenderer.toString((Boolean)value);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            string = VWFieldsCellRenderer.toString(date);
            string = string + " ";
        } else {
            string = value instanceof Double ? VWFieldsCellRenderer.toString((Double)value) : (value instanceof Float ? VWFieldsCellRenderer.toString((Float)value) : (value instanceof JLabel ? ((JLabel)value).getText() : (value instanceof VWAttachment ? VWFieldsCellRenderer.toString((VWAttachment)value) : (value instanceof VWParticipant ? VWFieldsCellRenderer.toString((VWParticipant)value) : (value instanceof VWXMLData ? VWFieldsCellRenderer.toString((VWXMLData)value) : (value instanceof VWGuid ? VWFieldsCellRenderer.toString((VWGuid)value) : value.toString()))))));
        }
        return string;
    }

    public static Number parse(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        return s_numberFormatter.parse(value);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        component.applyComponentOrientation(compOrientation);
        if (value == null) {
            if (component instanceof JLabel) {
                ((JLabel)component).setIcon(null);
                ((JLabel)component).setText(null);
                ((JLabel)component).setToolTipText(null);
            }
        } else if (value instanceof VWAttachment && component instanceof JComponent) {
            VWAttachment att = (VWAttachment)value;
            String string = VWFieldsCellRenderer.toString(att);
            ((JLabel)component).setText(string);
            String description = att.getAttachmentDescription();
            if (description != null && description.length() == 0) {
                description = null;
            }
            ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(description, 0));
        } else if (component instanceof JLabel) {
            if (value instanceof VWFieldDataForTable) {
                VWFieldDataForTable field = (VWFieldDataForTable)value;
                if (field.getValue() != null && field.getValue() instanceof JLabel) {
                    JLabel label = (JLabel)field.getValue();
                    ((JLabel)component).setIcon(label.getIcon());
                    ((JLabel)component).setText(label.getText());
                    ((JLabel)component).setToolTipText(label.getToolTipText());
                } else if (field.getValue() != null && field.getValue() instanceof VWXMLData) {
                    String string = VWFieldsCellRenderer.toString(field.getValue());
                    ((JLabel)component).setText(string);
                    ((JLabel)component).setToolTipText(VWStringUtils.formatXMLToolTip(string, 0));
                } else {
                    String string = VWFieldsCellRenderer.toString(field.getValue());
                    ((JLabel)component).setText(string);
                    ((JLabel)component).setToolTipText(VWStringUtils.formatToolTip(string, 0));
                }
            } else if (value instanceof ImageIcon) {
                ((JLabel)component).setText(null);
                ((JLabel)component).setHorizontalAlignment(0);
                ((JLabel)component).setIcon((Icon)value);
                ((JLabel)component).setToolTipText(((ImageIcon)value).getDescription());
            } else {
                String string = VWFieldsCellRenderer.toString(value);
                ((JLabel)component).setText(string);
                ((JLabel)component).setToolTipText(VWStringUtils.formatToolTip(string, 0));
            }
        }
        return component;
    }

    protected static String toString(Boolean value) {
        if (value != null) {
            if (value.booleanValue()) {
                return VWResource.s_true;
            }
            return VWResource.s_false;
        }
        return "";
    }

    protected static String toString(Date value) {
        long date;
        if (value != null && (date = value.getTime()) != NO_DATE && date != NO_TIME && date != NO_TIMER) {
            return DateFormat.getDateTimeInstance(2, 2).format(value);
        }
        return "";
    }

    protected static String toString(VWAttachment value) {
        String string = null;
        string = value.getType() == 5 ? value.getId() : value.getAttachmentName();
        if (string != null) {
            return string;
        }
        return "";
    }

    protected static String toString(VWParticipant value) {
        if (value != null) {
            VWParticipantItem pItem = new VWParticipantItem(value);
            return pItem.getDisplayName();
        }
        return null;
    }

    protected static String toString(Float value) {
        if (value == null) {
            return null;
        }
        return s_numberFormatter.format(value);
    }

    protected static String toString(Double value) {
        if (value == null) {
            return null;
        }
        return s_numberFormatter.format(value);
    }

    protected static String toString(VWXMLData value) {
        if (value == null) {
            return null;
        }
        String xmlString = value.getXML();
        if (xmlString.length() > 1024) {
            xmlString = xmlString.substring(0, 1024) + VWResource.s_dots;
        }
        return xmlString;
    }

    protected static String toString(VWGuid value) {
        if (!value.isUndefined()) {
            return value.toString();
        }
        return "";
    }
}

